/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Axes conv functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT TestReverseAxes()
{
	START_METHOD("ReverseAxes")

	HRESULT status = CONV_SUCCESS ;
	IWorkplane *l_wp=NULL ;
	IGeometric *l_face=NULL ;
	IDesign *localDesign=NULL ;
	ISketch *l_sketch=NULL ;
	IPartOthers *part1=NULL ;
	CString strwp = "PlaneofObject";
	CString strSketch = "ProfileSketch";

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// ReverseAxes
	AfxMessageBox("Testing Convenience Function ReverseAxes") ;
	IDirection *pDisp1 = NULL, *pDisp2 = NULL;
	status = ReverseAxes(&pDisp1, &pDisp2) ;
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("ReverseAxes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("ReverseAxes")
}

HRESULT TestRotateAxes()
{
	START_METHOD("RotateAxes")

	HRESULT status = CONV_SUCCESS ;
	IWorkplane *l_wp=NULL ;
	IGeometric *l_face=NULL ;
	IDesign *localDesign=NULL ;
	ISketch *l_sketch=NULL ;
	IPartOthers *part1=NULL ;
	CString strwp = "PlaneofObject";
	CString strSketch = "ProfileSketch";

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// RotateAxes
	AfxMessageBox("Testing Convenience Function RotateAxes") ;
	IDirection *pDisp1 = NULL, *pDisp2 = NULL;
	status = RotateAxes(0.78, &pDisp1, &pDisp2) ;
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("RotateAxes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("RotateAxes")

}

HRESULT TestTranslateAxes()
{
	START_METHOD("Translate Axes")

	HRESULT status = CONV_SUCCESS ;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL ;
	IWorkplane *activeWorkplane=NULL, *l_wp=NULL ;
	IGeometric *l_face=NULL ;
	IDesign *localDesign=NULL ;
	ISketch *l_sketch=NULL ;
	IPartOthers *part1=NULL ;
	CString strwp = "PlaneofObject";
	CString strSketch = "ProfileSketch";

	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// TranslateAxes
	AfxMessageBox("Testing Convenience Function TranslateAxes") ;
	IVector *pDisp1 = NULL;
	status = TranslateAxes(0.01, 0.01, &pDisp1) ;
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("TranslateAxes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("Translate Axes")
}

HRESULT TestRepositionAxes()
{
	START_METHOD("Reposition Axes")
	
	HRESULT status = CONV_SUCCESS ;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart=NULL ;
	IWorkplane *activeWorkplane=NULL, *l_wp=NULL ;
	IGeometric *l_face=NULL ;
	IDesign *localDesign=NULL ;
	ISketch *l_sketch=NULL ;
	IPartOthers *part1=NULL ;
	CString strwp = "PlaneofObject";
	CString strSketch = "ProfileSketch";

	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// RepositionAxes
	AfxMessageBox("Testing Convenience Function RepositionAxes") ;
	IVector *pDisp1 = NULL;
	IDirection *pDisp2 = NULL,  *pDisp3 = NULL;
	status = RepositionAxes(0.01, 0.01, 0.78, &pDisp1, &pDisp2, &pDisp3) ;
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Reposition Axes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("Reposition Axes")
}
